﻿using System;

public delegate void Calculation(decimal val1,
                                 decimal val2,
                                 ref decimal result);

public class MultiCastDelegateExample
{
    Calculation MyCalc1;
    Calculation MyCalc2;

    public void Add(decimal add1, decimal add2, ref decimal result)
    {
        result = add1 + add2;
        Console.WriteLine("add({0}, {1}) = {2}",
                            add1, add2, result);
        return;
    }

    public void Sub(decimal sub1, decimal sub2, ref decimal result)
    {
        result = sub1 - sub2;
        Console.WriteLine("sub({0}, {1}) = {2}",
                            sub1, sub2, result);
        return;
    }

    public decimal Add(decimal[] addList)
    {
        decimal total = 0;

        foreach (decimal number in addList)
        {
            total += number;
        }

        return total;
    }

    public static int Main(string[] args)
    {
        decimal result = 0.0m;
        MultiCastDelegateExample del = new MultiCastDelegateExample();

        del.MyCalc1 = new Calculation(del.Add);
        del.MyCalc2 = new Calculation(del.Sub);

        del.MyCalc1(5.35m, 9.71m, ref result);
        del.MyCalc2(8.39m, 1.75m, ref result);

        Console.WriteLine();

        Calculation MultiCalc = del.MyCalc1;
        MultiCalc += del.MyCalc2;

        MultiCalc(7.43m, 5.19m, ref result);

        Console.WriteLine();
        Console.WriteLine("MultiCalc(7.43m, 5.19m) = {0}",
                            result);

        // równość delegacji
        bool equal = del.MyCalc1 == del.MyCalc2; // zmienna equal jest równa false

        Console.ReadKey();
        return 0;
    }
}
